import JsSIP from 'jssip';

// SIP server configuration
const sipConfig = {
    wsServers: 'wss://your-sip-server.com', // Replace with your SIP server WebSocket URL
    uri: 'sip:username@your-sip-server.com', // Replace with SIP URI
    password: 'your_password', // Replace with SIP password
};

const socket = new JsSIP.WebSocketInterface(sipConfig.wsServers);
const configuration = {
    sockets: [socket],
    uri: sipConfig.uri,
    password: sipConfig.password,
};

// Create and start the User Agent
const ua = new JsSIP.UA(configuration);
ua.start();

ua.on('connected', () => console.log('Connected to SIP server'));
ua.on('registered', () => console.log('Successfully registered'));
ua.on('registrationFailed', (e) => console.error('Registration failed', e));
ua.on('newRTCSession', (data) => {
    const session = data.session;

    if (session.direction === 'incoming') {
        console.log('Incoming call from', session.remote_identity.uri.toString());
        // Auto-answer or show UI for user to answer
    }

    session.on('accepted', () => console.log('Call accepted'));
    session.on('ended', () => console.log('Call ended'));
    session.on('failed', (e) => console.error('Call failed', e));
});
