ua.on('newRTCSession', (data) => {
    const session = data.session;

    if (session.direction === 'incoming') {
        console.log('Incoming call from', session.remote_identity.uri.toString());

        // Prompt the user to accept or reject the call
        if (confirm('Accept call?')) {
            session.answer({
                mediaConstraints: { audio: true, video: false },
            });
            console.log('Call answered');
        } else {
            session.terminate();
            console.log('Call rejected');
        }
    }
});
